# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Connect to a catalog list
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the site collection
$siteUrl = "http://sharepoint/sitecollection"

# URL to the product catalog list
$catalogListUrl = "http://sharepoint/sites/catalog/Lists/Products"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the site collection
$site = Get-SPSite $siteUrl

# Create a new catalog connection manager for the site collection
$catalogManager = New-Object Microsoft.SharePoint.Publishing.CatalogConnectionManager -ArgumentList $site, $true

# Get the catalog list
$settings = [Microsoft.SharePoint.Publishing.PublishingCatalogUtility]::GetPublishingCatalog($site, $catalogListUrl)

# Add the catalog list to the connection manager
$catalogManager.AddCatalogConnection($settings)
$catalogManager.Update()

# Dispose of the site collection object
$site.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 